-- Database: klinik_db
-- Import via phpMyAdmin / mysql client.
-- Charset: utf8mb4

SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS=0;

DROP TABLE IF EXISTS appointment_details;
DROP TABLE IF EXISTS appointments;
DROP TABLE IF EXISTS services;
DROP TABLE IF EXISTS patients;
DROP TABLE IF EXISTS doctors;
DROP TABLE IF EXISTS users;

CREATE TABLE users (
  id INT AUTO_INCREMENT PRIMARY KEY,
  username VARCHAR(50) NOT NULL UNIQUE,
  password_hash VARCHAR(255) NOT NULL,
  nama VARCHAR(100) NOT NULL,
  role ENUM('admin','user') NOT NULL DEFAULT 'user',
  status ENUM('aktif','nonaktif') NOT NULL DEFAULT 'aktif',
  created_at DATETIME NOT NULL,
  updated_at DATETIME NOT NULL,
  last_login DATETIME NULL
) ENGINE=InnoDB;

CREATE TABLE doctors (
  id INT AUTO_INCREMENT PRIMARY KEY,
  kode_dokter VARCHAR(30) NOT NULL UNIQUE,
  nama VARCHAR(100) NOT NULL,
  spesialisasi VARCHAR(100) NOT NULL,
  no_hp VARCHAR(30) NOT NULL,
  email VARCHAR(120) NULL,
  alamat TEXT NULL,
  status ENUM('aktif','nonaktif') NOT NULL DEFAULT 'aktif',
  created_at DATETIME NOT NULL,
  updated_at DATETIME NOT NULL
) ENGINE=InnoDB;

CREATE TABLE patients (
  id INT AUTO_INCREMENT PRIMARY KEY,
  kode_pasien VARCHAR(30) NOT NULL UNIQUE,
  nama VARCHAR(100) NOT NULL,
  tgl_lahir DATE NOT NULL,
  jenis_kelamin ENUM('L','P') NOT NULL,
  no_hp VARCHAR(30) NOT NULL,
  alamat TEXT NULL,
  status ENUM('aktif','nonaktif') NOT NULL DEFAULT 'aktif',
  created_at DATETIME NOT NULL,
  updated_at DATETIME NOT NULL
) ENGINE=InnoDB;

CREATE TABLE services (
  id INT AUTO_INCREMENT PRIMARY KEY,
  kode_layanan VARCHAR(30) NOT NULL UNIQUE,
  nama VARCHAR(120) NOT NULL,
  deskripsi TEXT NULL,
  harga DECIMAL(12,2) NOT NULL DEFAULT 0,
  durasi_menit INT NOT NULL DEFAULT 0,
  status ENUM('aktif','nonaktif') NOT NULL DEFAULT 'aktif',
  created_at DATETIME NOT NULL,
  updated_at DATETIME NOT NULL
) ENGINE=InnoDB;

CREATE TABLE appointments (
  id INT AUTO_INCREMENT PRIMARY KEY,
  kode_reservasi VARCHAR(40) NOT NULL UNIQUE,
  pasien_id INT NOT NULL,
  dokter_id INT NOT NULL,
  tanggal DATE NOT NULL,
  jam TIME NOT NULL,
  keluhan VARCHAR(255) NULL,
  status ENUM('pending','confirmed','selesai','batal') NOT NULL DEFAULT 'pending',
  created_by INT NOT NULL,
  created_at DATETIME NOT NULL,
  updated_at DATETIME NOT NULL,
  CONSTRAINT fk_appt_pasien FOREIGN KEY (pasien_id) REFERENCES patients(id) ON DELETE RESTRICT,
  CONSTRAINT fk_appt_dokter FOREIGN KEY (dokter_id) REFERENCES doctors(id) ON DELETE RESTRICT,
  CONSTRAINT fk_appt_user FOREIGN KEY (created_by) REFERENCES users(id) ON DELETE RESTRICT
) ENGINE=InnoDB;

CREATE TABLE appointment_details (
  id INT AUTO_INCREMENT PRIMARY KEY,
  appointment_id INT NOT NULL,
  service_id INT NOT NULL,
  qty INT NOT NULL DEFAULT 1,
  harga DECIMAL(12,2) NOT NULL DEFAULT 0,     -- snapshot harga saat transaksi
  subtotal DECIMAL(12,2) NOT NULL DEFAULT 0,
  created_at DATETIME NOT NULL,
  CONSTRAINT fk_det_appt FOREIGN KEY (appointment_id) REFERENCES appointments(id) ON DELETE CASCADE,
  CONSTRAINT fk_det_service FOREIGN KEY (service_id) REFERENCES services(id) ON DELETE RESTRICT
) ENGINE=InnoDB;

-- Seed users (password demo)
INSERT INTO users (username,password_hash,nama,role,status,created_at,updated_at) VALUES
('admin', '$2y$10$VZxwzqQO/EmKbtf6xvKJ9O2b9oS4q2Vq4NQfUrt4R6cIYfG9x3gQO', 'Administrator', 'admin', 'aktif', NOW(), NOW()),
('user',  '$2y$10$zF0ixwB75bPZQn6pCRl7ReoBZm9Q5H2g9wK2m4w3xRkVJtB9wH1D6', 'Petugas', 'user', 'aktif', NOW(), NOW());

-- Note: hash di atas untuk admin123 dan user123.
-- (Jika ingin regenerate, pakai password_hash() di PHP)

-- Seed doctors/patients/services
INSERT INTO doctors (kode_dokter,nama,spesialisasi,no_hp,email,alamat,status,created_at,updated_at) VALUES
('D-001','dr. Andi Pratama','Umum','081234567890','andi@klinik.test','Jl. Mawar No. 1','aktif',NOW(),NOW()),
('D-002','dr. Siti Lestari','Gigi','081233334444','siti@klinik.test','Jl. Melati No. 2','aktif',NOW(),NOW());

INSERT INTO patients (kode_pasien,nama,tgl_lahir,jenis_kelamin,no_hp,alamat,status,created_at,updated_at) VALUES
('P-001','Budi Santoso','1998-06-10','L','081299991111','Jl. Kenanga No. 3','aktif',NOW(),NOW()),
('P-002','Rina Aulia','2000-01-02','P','081288882222','Jl. Anggrek No. 4','aktif',NOW(),NOW());

INSERT INTO services (kode_layanan,nama,deskripsi,harga,durasi_menit,status,created_at,updated_at) VALUES
('L-001','Konsultasi Umum','Konsultasi dokter umum',50000,20,'aktif',NOW(),NOW()),
('L-002','Pemeriksaan Gigi','Pemeriksaan kesehatan gigi',80000,30,'aktif',NOW(),NOW());

SET FOREIGN_KEY_CHECKS=1;
