<?php
require_once __DIR__ . '/../helpers/functions.php';

function current_user(): ?array {
    return $_SESSION['user'] ?? null;
}

function is_logged_in(): bool {
    return current_user() !== null;
}

function require_login(): void {
    if (!is_logged_in()) {
        redirect(url('login.php'));
    }
}

function require_admin(): void {
    $u = current_user();
    if (!$u || ($u['role'] ?? '') !== 'admin') {
        http_response_code(403);
        echo "Akses ditolak (admin only).";
        exit;
    }
}
