<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

/**
 * Pastikan BASE_URL selalu ada
 * - kalau config.php sudah diload => pakai BASE_URL dari sana
 * - kalau belum => deteksi otomatis dari URL yang sedang diakses
 */
if (!defined('BASE_URL')) {
    $scriptDir = str_replace('\\', '/', dirname($_SERVER['SCRIPT_NAME'] ?? ''));
    define('BASE_URL', rtrim($scriptDir, '/'));
}

function e(string $str): string {
    return htmlspecialchars($str, ENT_QUOTES, 'UTF-8');
}

function redirect(string $path): void {
    header("Location: " . $path);
    exit;
}

function url(string $path): string {
    return rtrim((string)BASE_URL, '/') . '/' . ltrim($path, '/');
}

function set_flash(string $type, string $message): void {
    $_SESSION['flash'] = ['type' => $type, 'message' => $message];
}

function get_flash(): ?array {
    if (!isset($_SESSION['flash'])) return null;
    $f = $_SESSION['flash'];
    unset($_SESSION['flash']);
    return $f;
}

function is_post(): bool {
    return ($_SERVER['REQUEST_METHOD'] ?? 'GET') === 'POST';
}

function require_fields(array $data, array $fields): array {
    $errors = [];
    foreach ($fields as $f) {
        if (!isset($data[$f]) || trim((string)$data[$f]) === '') {
            $errors[] = "Field <b>" . e($f) . "</b> wajib diisi.";
        }
    }
    return $errors;
}

function format_rupiah($n): string {
    return "Rp " . number_format((float)$n, 0, ',', '.');
}
