<?php
require_once __DIR__ . '/../config/db.php';
require_once __DIR__ . '/../helpers/functions.php';

if (session_status() === PHP_SESSION_NONE) session_start();
if (isset($_SESSION['user'])) {
    redirect(url('index.php?page=dashboard'));
}

$errors = [];
if (is_post()) {
    $username = trim($_POST['username'] ?? '');
    $password = $_POST['password'] ?? '';

    $errors = require_fields($_POST, ['username', 'password']);

    if (!$errors) {
        $stmt = $pdo->prepare("SELECT * FROM users WHERE username = ? LIMIT 1");
        $stmt->execute([$username]);
        $user = $stmt->fetch();

        if (!$user || !password_verify($password, $user['password_hash'])) {
            $errors[] = "Username atau password salah.";
        } elseif (($user['status'] ?? 'aktif') !== 'aktif') {
            $errors[] = "Akun tidak aktif.";
        } else {
            $_SESSION['user'] = [
                'id'       => $user['id'],
                'username' => $user['username'],
                'nama'     => $user['nama'],
                'role'     => $user['role'],
            ];
            $pdo->prepare("UPDATE users SET last_login = NOW() WHERE id = ?")->execute([$user['id']]);
            set_flash('success', 'Login berhasil.');
            redirect(url('index.php?page=dashboard'));
        }
    }
}
?>
<!doctype html>
<html lang="id">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Masuk - <?= e(APP_NAME) ?></title>

  <!-- Font modern -->
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">

  <!-- Bootswatch (samakan dengan dashboard) -->
  <link href="https://cdn.jsdelivr.net/npm/bootswatch@5.3.3/dist/flatly/bootstrap.min.css" rel="stylesheet">

  <!-- Icons -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css" rel="stylesheet">

  <style>
    :root{ --radius: 18px; }
    body{
      font-family: Inter, system-ui, -apple-system, Segoe UI, Roboto, Arial, sans-serif;
      min-height: 100vh;
      background:
        radial-gradient(1200px 600px at 10% 10%, rgba(13,110,253,.18), transparent 60%),
        radial-gradient(900px 500px at 90% 20%, rgba(32,201,151,.14), transparent 55%),
        #f6f8fb;
    }
    .auth-card{
      border: 0;
      border-radius: var(--radius);
      box-shadow: 0 16px 40px rgba(0,0,0,.08);
      overflow: hidden;
    }
    .auth-left{
      background: linear-gradient(135deg, rgba(13,110,253,.95), rgba(32,201,151,.92));
      color: #fff;
    }
    .brand-badge{
      width: 48px; height: 48px;
      border-radius: 14px;
      display:flex; align-items:center; justify-content:center;
      background: rgba(255,255,255,.18);
      border: 1px solid rgba(255,255,255,.25);
    }
    .form-control{
      border-radius: 14px;
      padding: .7rem .9rem;
    }
    .btn{
      border-radius: 14px;
      padding: .7rem 1rem;
      font-weight: 600;
    }
    .divider{
      height: 1px;
      background: rgba(255,255,255,.22);
      margin: 16px 0;
    }
  </style>
</head>

<body>
<div class="container py-5">
  <div class="row justify-content-center align-items-center" style="min-height: calc(100vh - 6rem);">
    <div class="col-12 col-lg-9 col-xl-8">
      <div class="card auth-card">
        <div class="row g-0">

          <!-- LEFT PANEL -->
          <div class="col-12 col-lg-5 auth-left p-4 p-lg-5">
            <div class="d-flex align-items-center gap-3 mb-3">
              <div class="brand-badge">
                <i class="bi bi-hospital fs-3"></i>
              </div>
              <div>
                <div class="fw-bold fs-5"><?= e(APP_NAME) ?></div>
                <div class="small opacity-75">Sistem Reservasi Klinik</div>
              </div>
            </div>

            <div class="divider"></div>

            <div class="fw-semibold mb-2">Masuk untuk melanjutkan</div>
            <div class="small opacity-75">
              Kelola data dokter, pasien, layanan, dan reservasi dengan tampilan yang rapi dan cepat.
            </div>

            <div class="mt-4 small opacity-75">
              <i class="bi bi-shield-check me-1"></i> Aman • <i class="bi bi-lightning-charge me-1"></i> Cepat • <i class="bi bi-stars me-1"></i> Modern
            </div>
          </div>

          <!-- RIGHT PANEL -->
          <div class="col-12 col-lg-7 p-4 p-lg-5 bg-white">
            <div class="mb-3">
              <div class="text-uppercase small text-secondary">Login</div>
              <h1 class="h3 fw-bold mb-1">Selamat datang kembali</h1>
              <div class="text-secondary">Silakan masuk menggunakan akun Anda.</div>
            </div>

            <?php if ($errors): ?>
              <div class="alert alert-danger">
                <div class="fw-semibold mb-1"><i class="bi bi-exclamation-triangle me-1"></i> Gagal login</div>
                <ul class="mb-0">
                  <?php foreach ($errors as $er): ?><li><?= e($er) ?></li><?php endforeach; ?>
                </ul>
              </div>
            <?php endif; ?>

            <form method="post" class="mt-3">
              <div class="mb-3">
                <label class="form-label fw-semibold">Username</label>
                <div class="input-group">
                  <span class="input-group-text bg-white"><i class="bi bi-person"></i></span>
                  <input name="username" class="form-control"
                         value="<?= e($_POST['username'] ?? '') ?>"
                         placeholder="Masukkan username"
                         autocomplete="username"
                         autofocus>
                </div>
              </div>

              <div class="mb-3">
                <label class="form-label fw-semibold">Password</label>
                <div class="input-group">
                  <span class="input-group-text bg-white"><i class="bi bi-key"></i></span>
                  <input type="password" name="password" class="form-control"
                         placeholder="Masukkan password"
                         autocomplete="current-password">
                </div>
              </div>

              <button class="btn btn-primary w-100">
                <i class="bi bi-box-arrow-in-right me-1"></i> Masuk
              </button>

              <div class="mt-3 small text-secondary">
                Jika lupa password, minta admin untuk reset akun.
              </div>
            </form>

          </div>
        </div>
      </div>

      <div class="text-center mt-3 small text-secondary">
        © <?= date('Y') ?> <?= e(APP_NAME) ?>
      </div>
    </div>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
