<?php
require_once __DIR__ . '/_shared.php';

$id = (int)($_GET['id'] ?? 0);
if (!$id) {
    set_flash('danger', 'ID reservasi tidak valid.');
    redirect(url('index.php?page=appointments'));
}

$stmt = $pdo->prepare("
SELECT a.*, p.nama AS pasien_nama, p.no_hp AS pasien_hp, d.nama AS dokter_nama, d.spesialisasi
FROM appointments a
JOIN patients p ON p.id=a.pasien_id
JOIN doctors d ON d.id=a.dokter_id
WHERE a.id=?
");
$stmt->execute([$id]);
$appt = $stmt->fetch();
if (!$appt) {
    set_flash('danger', 'Reservasi tidak ditemukan.');
    redirect(url('index.php?page=appointments'));
}

$stmt2 = $pdo->prepare("
SELECT ad.*, s.nama AS layanan_nama
FROM appointment_details ad
JOIN services s ON s.id=ad.service_id
WHERE ad.appointment_id=?
");
$stmt2->execute([$id]);
$details = $stmt2->fetchAll();

$total = 0;
foreach ($details as $d) $total += (float)$d['subtotal'];
?>

<!-- HERO -->
<div class="page-hero mb-4">
  <div class="d-flex flex-wrap align-items-center justify-content-between gap-3">
    <div>
      <div class="text-uppercase small opacity-75">Reservasi</div>
      <h1 class="h3 mb-1 fw-bold">Detail Reservasi</h1>
      <div class="text-secondary">
        Kode: <span class="fw-semibold"><?= e($appt['kode_reservasi']) ?></span>
      </div>
    </div>

    <div class="d-flex flex-wrap gap-2">
      <a class="btn btn-outline-primary" href="<?= url('index.php?page=appointments&action=form&id='.(int)$id) ?>">
        <i class="bi bi-pencil me-1"></i> Edit
      </a>
      <a class="btn btn-outline-secondary" href="<?= url('index.php?page=appointments') ?>">
        <i class="bi bi-arrow-left me-1"></i> Kembali
      </a>
    </div>
  </div>
</div>

<div class="row g-3">

  <!-- PASIEN -->
  <div class="col-12 col-lg-6">
    <div class="card">
      <div class="card-body">
        <div class="d-flex align-items-center justify-content-between">
          <div>
            <div class="text-secondary small">Pasien</div>
            <div class="fw-bold fs-5"><?= e($appt['pasien_nama']) ?></div>
            <div class="text-secondary"><?= e($appt['pasien_hp'] ?: '-') ?></div>
          </div>
          <div class="icon-btn text-white" style="background: linear-gradient(135deg,#0d6efd,#20c997);">
            <i class="bi bi-person-heart fs-5"></i>
          </div>
        </div>
      </div>
    </div>
  </div>

  <!-- DOKTER -->
  <div class="col-12 col-lg-6">
    <div class="card">
      <div class="card-body">
        <div class="d-flex align-items-center justify-content-between">
          <div>
            <div class="text-secondary small">Dokter</div>
            <div class="fw-bold fs-5"><?= e($appt['dokter_nama']) ?></div>
            <div class="text-secondary"><?= e($appt['spesialisasi'] ?: '-') ?></div>
          </div>
          <div class="icon-btn text-white" style="background: linear-gradient(135deg,#6f42c1,#0d6efd);">
            <i class="bi bi-person-badge fs-5"></i>
          </div>
        </div>
      </div>
    </div>
  </div>

  <!-- RINGKASAN -->
  <div class="col-12">
    <div class="card">
      <div class="card-body">
        <div class="row g-3">
          <div class="col-6 col-md-3">
            <div class="text-secondary small">Tanggal</div>
            <div class="fw-semibold"><?= e($appt['tanggal']) ?></div>
          </div>
          <div class="col-6 col-md-3">
            <div class="text-secondary small">Jam</div>
            <div class="fw-semibold"><?= e(substr((string)$appt['jam'], 0, 5)) ?></div>
          </div>
          <div class="col-6 col-md-3">
            <div class="text-secondary small">Status</div>
            <div><?= badge_status($appt['status']) ?></div>
          </div>
          <div class="col-6 col-md-3">
            <div class="text-secondary small">Total</div>
            <div class="fw-bold"><?= e(format_rupiah($total)) ?></div>
          </div>

          <div class="col-12">
            <div class="text-secondary small">Keluhan</div>
            <div class="fw-semibold"><?= e($appt['keluhan'] ?: '-') ?></div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <!-- DETAIL LAYANAN -->
  <div class="col-12">
    <div class="card">
      <div class="card-body">
        <div class="d-flex align-items-center justify-content-between mb-3">
          <div>
            <div class="fw-bold">Detail Layanan</div>
            <div class="text-secondary small">Daftar layanan yang dipilih pada reservasi ini</div>
          </div>
        </div>

        <div class="table-responsive">
          <table class="table table-modern align-middle">
            <thead>
              <tr>
                <th style="width:70px">#</th>
                <th>Layanan</th>
                <th style="width:110px">Qty</th>
                <th style="width:170px">Harga</th>
                <th style="width:170px">Subtotal</th>
              </tr>
            </thead>
            <tbody>
              <?php if (!$details): ?>
                <tr>
                  <td colspan="5" class="text-center text-secondary py-4">Tidak ada detail layanan.</td>
                </tr>
              <?php endif; ?>

              <?php foreach ($details as $i => $d): ?>
              <tr>
                <td><?= $i+1 ?></td>
                <td class="fw-semibold"><?= e($d['layanan_nama']) ?></td>
                <td><?= e((string)$d['qty']) ?></td>
                <td><?= e(format_rupiah($d['harga'])) ?></td>
                <td class="fw-semibold"><?= e(format_rupiah($d['subtotal'])) ?></td>
              </tr>
              <?php endforeach; ?>

              <tr>
                <td colspan="4" class="text-end fw-bold">TOTAL</td>
                <td class="fw-bold"><?= e(format_rupiah($total)) ?></td>
              </tr>
            </tbody>
          </table>
        </div>

      </div>
    </div>
  </div>

</div>
