<?php
require_once __DIR__ . '/_shared.php';

$action = $_GET['action'] ?? 'list';
$id = (int)($_GET['id'] ?? 0);
$u = current_user();

if ($action === 'delete' && $id) {
    $pdo->prepare("DELETE FROM appointment_details WHERE appointment_id=?")->execute([$id]);
    $pdo->prepare("DELETE FROM appointments WHERE id=?")->execute([$id]);
    set_flash('success', 'Reservasi berhasil dihapus.');
    redirect(url('index.php?page=appointments'));
}

$doctors = $pdo->query("SELECT id, nama, spesialisasi FROM doctors WHERE status='aktif' ORDER BY nama")->fetchAll();
$patients = $pdo->query("SELECT id, nama FROM patients WHERE status='aktif' ORDER BY nama")->fetchAll();
$services = $pdo->query("SELECT id, nama, harga FROM services WHERE status='aktif' ORDER BY nama")->fetchAll();

$errors = [];
if (is_post()) {
    $data = [
        'kode_reservasi' => trim($_POST['kode_reservasi'] ?? ''),
        'pasien_id' => (int)($_POST['pasien_id'] ?? 0),
        'dokter_id' => (int)($_POST['dokter_id'] ?? 0),
        'tanggal' => trim($_POST['tanggal'] ?? ''),
        'jam' => trim($_POST['jam'] ?? ''),
        'keluhan' => trim($_POST['keluhan'] ?? ''),
        'status' => trim($_POST['status'] ?? 'pending'),
    ];
    $errors = require_fields($_POST, ['kode_reservasi','pasien_id','dokter_id','tanggal','jam','status']);

    $service_ids = $_POST['service_id'] ?? [];
    $qtys = $_POST['qty'] ?? [];
    if (!is_array($service_ids) || !is_array($qtys)) {
        $errors[] = "Detail layanan tidak valid.";
    } else {
        // remove empty rows
        $detail = [];
        for ($i=0; $i<count($service_ids); $i++) {
            $sid = (int)($service_ids[$i] ?? 0);
            $qty = (int)($qtys[$i] ?? 0);
            if ($sid > 0 && $qty > 0) {
                $detail[] = ['service_id' => $sid, 'qty' => $qty];
            }
        }
        if (count($detail) === 0) {
            $errors[] = "Minimal pilih 1 layanan dengan qty > 0.";
        }
    }

    if (!$errors) {
        $pdo->beginTransaction();
        try {
            $appt_id = (int)($_POST['id'] ?? 0);
            if ($appt_id > 0) {
                $pdo->prepare("UPDATE appointments SET kode_reservasi=?, pasien_id=?, dokter_id=?, tanggal=?, jam=?, keluhan=?, status=?, updated_at=NOW() WHERE id=?")
                    ->execute([$data['kode_reservasi'],$data['pasien_id'],$data['dokter_id'],$data['tanggal'],$data['jam'],$data['keluhan'],$data['status'],$appt_id]);
                // replace details
                $pdo->prepare("DELETE FROM appointment_details WHERE appointment_id=?")->execute([$appt_id]);
            } else {
                $pdo->prepare("INSERT INTO appointments (kode_reservasi,pasien_id,dokter_id,tanggal,jam,keluhan,status,created_by,created_at,updated_at) VALUES (?,?,?,?,?,?,?,?,NOW(),NOW())")
                    ->execute([$data['kode_reservasi'],$data['pasien_id'],$data['dokter_id'],$data['tanggal'],$data['jam'],$data['keluhan'],$data['status'], $u['id']]);
                $appt_id = (int)$pdo->lastInsertId();
            }

            // details with price snapshot
            $priceStmt = $pdo->prepare("SELECT harga FROM services WHERE id=?");
            $insDet = $pdo->prepare("INSERT INTO appointment_details (appointment_id, service_id, qty, harga, subtotal, created_at) VALUES (?,?,?,?,?,NOW())");
            foreach ($detail as $d) {
                $priceStmt->execute([$d['service_id']]);
                $harga = (float)($priceStmt->fetch()['harga'] ?? 0);
                $subtotal = $harga * $d['qty'];
                $insDet->execute([$appt_id, $d['service_id'], $d['qty'], $harga, $subtotal]);
            }

            $pdo->commit();
            set_flash('success', 'Reservasi berhasil disimpan.');
            redirect(url('index.php?page=appointments'));
        } catch (Throwable $e) {
            $pdo->rollBack();
            $errors[] = "Gagal menyimpan reservasi: " . e($e->getMessage());
            $action = 'form';
            $id = (int)($_POST['id'] ?? 0);
        }
    } else {
        $action = 'form';
        $id = (int)($_POST['id'] ?? 0);
    }
}

$edit = null;
$editDetails = [];
if ($action === 'form' && $id) {
    $stmt = $pdo->prepare("SELECT * FROM appointments WHERE id=?");
    $stmt->execute([$id]);
    $edit = $stmt->fetch();

    $stmt2 = $pdo->prepare("SELECT * FROM appointment_details WHERE appointment_id=?");
    $stmt2->execute([$id]);
    $editDetails = $stmt2->fetchAll();
}

$q = trim($_GET['q'] ?? '');
$params = [];
$where = "";
if ($q !== '') {
    $where = "WHERE a.kode_reservasi LIKE ? OR p.nama LIKE ? OR d.nama LIKE ?";
    $like = "%$q%";
    $params = [$like, $like, $like];
}

$stmt = $pdo->prepare("
SELECT a.*, p.nama AS pasien_nama, d.nama AS dokter_nama
FROM appointments a
JOIN patients p ON p.id=a.pasien_id
JOIN doctors d ON d.id=a.dokter_id
$where
ORDER BY a.id DESC
");
$stmt->execute($params);
$rows = $stmt->fetchAll();
?>

<div class="d-flex align-items-center justify-content-between mb-3">
  <div>
    <h1 class="h3 mb-1">Transaksi Reservasi</h1>
    <div class="text-secondary">Reservasi dokter + detail layanan</div>
  </div>
  <a class="btn btn-primary" href="<?= url('index.php?page=appointments&action=form') ?>"><i class="bi bi-plus-lg"></i> Tambah</a>
</div>

<?php if ($action === 'form'): ?>
<div class="card shadow-sm">
  <div class="card-body">
    <h2 class="h5 mb-3"><?= $edit ? 'Edit Reservasi' : 'Tambah Reservasi' ?></h2>

    <?php if ($errors): ?>
      <div class="alert alert-danger">
        <ul class="mb-0">
          <?php foreach ($errors as $er): ?><li><?= $er ?></li><?php endforeach; ?>
        </ul>
      </div>
    <?php endif; ?>

    <form method="post" class="row g-3">
      <input type="hidden" name="id" value="<?= e((string)($edit['id'] ?? ($_POST['id'] ?? ''))) ?>">

      <div class="col-md-4">
        <label class="form-label">Kode Reservasi</label>
        <input name="kode_reservasi" class="form-control" value="<?= e($edit['kode_reservasi'] ?? ($_POST['kode_reservasi'] ?? 'RSV-' . date('Ymd-His'))) ?>">
      </div>

      <div class="col-md-4">
        <label class="form-label">Pasien</label>
        <?php $pid = (int)($edit['pasien_id'] ?? ($_POST['pasien_id'] ?? 0)); ?>
        <select name="pasien_id" class="form-select">
          <option value="">-- pilih pasien --</option>
          <?php foreach ($patients as $p): ?>
            <option value="<?= (int)$p['id'] ?>" <?= $pid===(int)$p['id']?'selected':'' ?>><?= e($p['nama']) ?></option>
          <?php endforeach; ?>
        </select>
      </div>

      <div class="col-md-4">
        <label class="form-label">Dokter</label>
        <?php $did = (int)($edit['dokter_id'] ?? ($_POST['dokter_id'] ?? 0)); ?>
        <select name="dokter_id" class="form-select">
          <option value="">-- pilih dokter --</option>
          <?php foreach ($doctors as $d): ?>
            <option value="<?= (int)$d['id'] ?>" <?= $did===(int)$d['id']?'selected':'' ?>><?= e($d['nama']) ?> (<?= e($d['spesialisasi']) ?>)</option>
          <?php endforeach; ?>
        </select>
      </div>

      <div class="col-md-3">
        <label class="form-label">Tanggal</label>
        <input type="date" name="tanggal" class="form-control" value="<?= e($edit['tanggal'] ?? ($_POST['tanggal'] ?? date('Y-m-d'))) ?>">
      </div>

      <div class="col-md-3">
        <label class="form-label">Jam</label>
        <input type="time" name="jam" class="form-control" value="<?= e($edit['jam'] ?? ($_POST['jam'] ?? date('H:i'))) ?>">
      </div>

      <div class="col-md-3">
        <label class="form-label">Status</label>
        <?php $st = $edit['status'] ?? ($_POST['status'] ?? 'pending'); ?>
        <select name="status" class="form-select">
          <option value="pending" <?= $st==='pending'?'selected':'' ?>>pending</option>
          <option value="confirmed" <?= $st==='confirmed'?'selected':'' ?>>confirmed</option>
          <option value="selesai" <?= $st==='selesai'?'selected':'' ?>>selesai</option>
          <option value="batal" <?= $st==='batal'?'selected':'' ?>>batal</option>
        </select>
      </div>

      <div class="col-md-3">
        <label class="form-label">Keluhan (opsional)</label>
        <input name="keluhan" class="form-control" value="<?= e($edit['keluhan'] ?? ($_POST['keluhan'] ?? '')) ?>">
      </div>

      <div class="col-12">
        <div class="d-flex justify-content-between align-items-center">
          <h3 class="h6 mb-2">Detail Layanan</h3>
          <button class="btn btn-sm btn-outline-primary" type="button" id="btnAddServiceRow">
            <i class="bi bi-plus-lg"></i> Tambah Baris
          </button>
        </div>

        <div class="table-responsive">
          <table class="table table-sm align-middle">
            <thead>
              <tr>
                <th style="width: 70%;">Layanan</th>
                <th style="width: 20%;">Qty</th>
                <th class="text-end" style="width: 10%;">Aksi</th>
              </tr>
            </thead>
            <tbody id="serviceRows">
              <?php
                $details = [];
                if ($editDetails) $details = $editDetails;
                elseif (isset($_POST['service_id'], $_POST['qty']) && is_array($_POST['service_id'])) {
                  for ($i=0; $i<count($_POST['service_id']); $i++) {
                    $details[] = ['service_id' => (int)($_POST['service_id'][$i] ?? 0), 'qty' => (int)($_POST['qty'][$i] ?? 0)];
                  }
                } else {
                  $details = [['service_id' => 0, 'qty' => 1]];
                }
              ?>
              <?php foreach ($details as $det): ?>
              <tr>
                <td>
                  <select name="service_id[]" class="form-select form-select-sm">
                    <option value="">-- pilih layanan --</option>
                    <?php foreach ($services as $s): ?>
                      <option value="<?= (int)$s['id'] ?>" <?= ((int)$det['service_id']===(int)$s['id'])?'selected':'' ?>>
                        <?= e($s['nama']) ?> (<?= e(format_rupiah($s['harga'])) ?>)
                      </option>
                    <?php endforeach; ?>
                  </select>
                </td>
                <td><input type="number" min="1" name="qty[]" class="form-control form-control-sm" value="<?= e((string)($det['qty'] ?? 1)) ?>"></td>
                <td class="text-end">
                  <button class="btn btn-sm btn-outline-danger" type="button" data-action="remove-row"><i class="bi bi-x-lg"></i></button>
                </td>
              </tr>
              <?php endforeach; ?>
            </tbody>
          </table>
        </div>

        <template id="serviceRowTemplate">
          <tr>
            <td>
              <select name="service_id[]" class="form-select form-select-sm">
                <option value="">-- pilih layanan --</option>
                <?php foreach ($services as $s): ?>
                  <option value="<?= (int)$s['id'] ?>"><?= e($s['nama']) ?> (<?= e(format_rupiah($s['harga'])) ?>)</option>
                <?php endforeach; ?>
              </select>
            </td>
            <td><input type="number" min="1" name="qty[]" class="form-control form-control-sm" value="1"></td>
            <td class="text-end">
              <button class="btn btn-sm btn-outline-danger" type="button" data-action="remove-row"><i class="bi bi-x-lg"></i></button>
            </td>
          </tr>
        </template>
      </div>

      <div class="col-12 d-flex gap-2">
        <button class="btn btn-primary">Simpan</button>
        <a class="btn btn-outline-secondary" href="<?= url('index.php?page=appointments') ?>">Kembali</a>
      </div>
    </form>
  </div>
</div>

<?php else: ?>

<div class="card shadow-sm">
  <div class="card-body">
    <form class="row g-2 mb-3" method="get">
      <input type="hidden" name="page" value="appointments">
      <div class="col-12 col-md-6">
        <input class="form-control" name="q" placeholder="Cari kode/pasien/dokter..." value="<?= e($q) ?>">
      </div>
      <div class="col-auto">
        <button class="btn btn-outline-primary"><i class="bi bi-search"></i> Cari</button>
      </div>
      <div class="col-auto">
        <a class="btn btn-outline-secondary" href="<?= url('index.php?page=appointments') ?>">Reset</a>
      </div>
    </form>

    <div class="table-responsive">
      <table class="table table-sm align-middle">
        <thead>
          <tr>
            <th>#</th>
            <th>Kode</th>
            <th>Pasien</th>
            <th>Dokter</th>
            <th>Tanggal</th>
            <th>Jam</th>
            <th>Status</th>
            <th class="text-end">Aksi</th>
          </tr>
        </thead>
        <tbody>
          <?php if (!$rows): ?>
            <tr><td colspan="8" class="text-center text-secondary py-4">Belum ada data.</td></tr>
          <?php endif; ?>
          <?php foreach ($rows as $i => $r): ?>
            <tr>
              <td><?= $i+1 ?></td>
              <td><?= e($r['kode_reservasi']) ?></td>
              <td><?= e($r['pasien_nama']) ?></td>
              <td><?= e($r['dokter_nama']) ?></td>
              <td><?= e($r['tanggal']) ?></td>
              <td><?= e(substr($r['jam'],0,5)) ?></td>
              <td><?= badge_status($r['status']) ?></td>
              <td class="text-end">
                <a class="btn btn-sm btn-outline-secondary" href="<?= url('index.php?page=appointment_view&id=' . (int)$r['id']) ?>"><i class="bi bi-eye"></i></a>
                <a class="btn btn-sm btn-outline-primary" href="<?= url('index.php?page=appointments&action=form&id=' . (int)$r['id']) ?>"><i class="bi bi-pencil"></i></a>
                <a class="btn btn-sm btn-outline-danger" onclick="return confirm('Hapus reservasi ini?')" href="<?= url('index.php?page=appointments&action=delete&id=' . (int)$r['id']) ?>"><i class="bi bi-trash"></i></a>
              </td>
            </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
    </div>

  </div>
</div>
<?php endif; ?>
