<?php

if (!isset($u) || !$u) {
  $u = current_user();
}

// Statistik
$cntDoctors  = (int)$pdo->query("SELECT COUNT(*) c FROM doctors")->fetch()['c'];
$cntPatients = (int)$pdo->query("SELECT COUNT(*) c FROM patients")->fetch()['c'];
$cntServices = (int)$pdo->query("SELECT COUNT(*) c FROM services")->fetch()['c'];
$cntAppt     = (int)$pdo->query("SELECT COUNT(*) c FROM appointments")->fetch()['c'];

// Reservasi terbaru
$stmt = $pdo->query("
  SELECT a.id, a.kode_reservasi, a.tanggal, a.jam, a.status,
         p.nama AS pasien_nama, d.nama AS dokter_nama
  FROM appointments a
  JOIN patients p ON p.id = a.pasien_id
  JOIN doctors d ON d.id = a.dokter_id
  ORDER BY a.id DESC
  LIMIT 6
");
$latest = $stmt->fetchAll();

function status_class(string $s): string {
  $s = strtolower(trim($s));
  return match($s) {
    'confirmed', 'konfirmasi', 'disetujui' => 'success',
    'selesai', 'done'                     => 'primary',
    'batal', 'cancelled', 'canceled'      => 'danger',
    default                               => 'warning',
  };
}

// Nama untuk greeting
$displayName = $u['nama'] ?? $u['username'] ?? 'Admin';

// Tanggal hari ini (Indonesia)
$hariIni = date('d M Y');
?>

<!-- HERO -->
<div class="page-hero mb-4">
  <div class="d-flex flex-wrap align-items-center justify-content-between gap-3">
    <div>
      <div class="text-uppercase small opacity-75">Dashboard</div>
      <h1 class="h3 mb-1 fw-bold">Selamat Datang, <?= e($displayName) ?> 👋</h1>
      <div class="text-secondary">
        Pantau aktivitas klinik hari ini (<?= e($hariIni) ?>) dan kelola semua data dengan cepat.
      </div>
    </div>

    <div class="d-flex flex-wrap gap-2">
      <a class="btn btn-primary px-4" href="<?= url('index.php?page=appointments&action=form') ?>">
        <i class="bi bi-plus-lg me-1"></i> Buat Reservasi
      </a>
      <a class="btn btn-outline-primary" href="<?= url('index.php?page=patients&action=form') ?>">
        <i class="bi bi-person-plus me-1"></i> Tambah Pasien
      </a>
      <a class="btn btn-outline-secondary" href="<?= url('index.php?page=doctors&action=form') ?>">
        <i class="bi bi-person-badge me-1"></i> Tambah Dokter
      </a>
    </div>
  </div>
</div>

<!-- KPI CARDS -->
<div class="row g-3 mb-4">
  <div class="col-12 col-md-6 col-xl-3">
    <div class="card card-hover">
      <div class="card-body d-flex align-items-center justify-content-between">
        <div>
          <div class="text-secondary small">Dokter</div>
          <div class="display-6 fw-bold mb-0"><?= e((string)$cntDoctors) ?></div>
        </div>
        <div class="icon-btn text-white" style="background: linear-gradient(135deg,#0d6efd,#20c997);">
          <i class="bi bi-person-badge fs-5"></i>
        </div>
      </div>
      <div class="px-3 pb-3">
        <a class="small fw-semibold" href="<?= url('index.php?page=doctors') ?>">
          Kelola dokter <i class="bi bi-arrow-right"></i>
        </a>
      </div>
    </div>
  </div>

  <div class="col-12 col-md-6 col-xl-3">
    <div class="card card-hover">
      <div class="card-body d-flex align-items-center justify-content-between">
        <div>
          <div class="text-secondary small">Pasien</div>
          <div class="display-6 fw-bold mb-0"><?= e((string)$cntPatients) ?></div>
        </div>
        <div class="icon-btn text-white" style="background: linear-gradient(135deg,#6f42c1,#0d6efd);">
          <i class="bi bi-people fs-5"></i>
        </div>
      </div>
      <div class="px-3 pb-3">
        <a class="small fw-semibold" href="<?= url('index.php?page=patients') ?>">
          Kelola pasien <i class="bi bi-arrow-right"></i>
        </a>
      </div>
    </div>
  </div>

  <div class="col-12 col-md-6 col-xl-3">
    <div class="card card-hover">
      <div class="card-body d-flex align-items-center justify-content-between">
        <div>
          <div class="text-secondary small">Layanan</div>
          <div class="display-6 fw-bold mb-0"><?= e((string)$cntServices) ?></div>
        </div>
        <div class="icon-btn text-white" style="background: linear-gradient(135deg,#fd7e14,#20c997);">
          <i class="bi bi-clipboard2-pulse fs-5"></i>
        </div>
      </div>
      <div class="px-3 pb-3">
        <a class="small fw-semibold" href="<?= url('index.php?page=services') ?>">
          Kelola layanan <i class="bi bi-arrow-right"></i>
        </a>
      </div>
    </div>
  </div>

  <div class="col-12 col-md-6 col-xl-3">
    <div class="card card-hover">
      <div class="card-body d-flex align-items-center justify-content-between">
        <div>
          <div class="text-secondary small">Reservasi</div>
          <div class="display-6 fw-bold mb-0"><?= e((string)$cntAppt) ?></div>
        </div>
        <div class="icon-btn text-white" style="background: linear-gradient(135deg,#198754,#20c997);">
          <i class="bi bi-calendar2-check fs-5"></i>
        </div>
      </div>
      <div class="px-3 pb-3">
        <a class="small fw-semibold" href="<?= url('index.php?page=appointments') ?>">
          Lihat reservasi <i class="bi bi-arrow-right"></i>
        </a>
      </div>
    </div>
  </div>
</div>

<!-- LATEST APPOINTMENTS -->
<div class="card">
  <div class="card-body">
    <div class="d-flex align-items-center justify-content-between gap-2 mb-3">
      <div>
        <h2 class="h5 mb-0 fw-bold">Reservasi Terbaru</h2>
        <div class="text-secondary small">6 transaksi terakhir</div>
      </div>
      <a class="btn btn-outline-primary btn-sm" href="<?= url('index.php?page=appointments') ?>">
        <i class="bi bi-arrow-right"></i> Semua Reservasi
      </a>
    </div>

    <div class="table-responsive">
      <table class="table table-modern align-middle">
        <thead>
          <tr>
            <th>Kode</th>
            <th>Pasien</th>
            <th>Dokter</th>
            <th>Tanggal</th>
            <th>Jam</th>
            <th>Status</th>
            <th class="text-end">Aksi</th>
          </tr>
        </thead>
        <tbody>
          <?php if (!$latest): ?>
            <tr>
              <td colspan="7" class="text-center text-secondary py-4">
                Belum ada reservasi. Klik <b>Buat Reservasi</b> untuk mulai.
              </td>
            </tr>
          <?php endif; ?>

          <?php foreach ($latest as $r): ?>
            <tr>
              <td class="fw-semibold"><?= e($r['kode_reservasi']) ?></td>
              <td><?= e($r['pasien_nama']) ?></td>
              <td><?= e($r['dokter_nama']) ?></td>
              <td><?= e($r['tanggal']) ?></td>
              <td><?= e(substr((string)$r['jam'], 0, 5)) ?></td>
              <td>
                <span class="badge text-bg-<?= e(status_class((string)$r['status'])) ?>">
                  <?= e((string)$r['status']) ?>
                </span>
              </td>
              <td class="text-end">
                <a class="btn btn-outline-secondary btn-sm icon-btn"
                   href="<?= url('index.php?page=appointment_view&id='.(int)$r['id']) ?>"
                   title="Detail">
                  <i class="bi bi-eye"></i>
                </a>
                <a class="btn btn-outline-primary btn-sm icon-btn"
                   href="<?= url('index.php?page=appointments&action=form&id='.(int)$r['id']) ?>"
                   title="Edit">
                  <i class="bi bi-pencil"></i>
                </a>
              </td>
            </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>
