<?php
require_once __DIR__ . '/_shared.php';

$action = $_GET['action'] ?? 'list';
$id = (int)($_GET['id'] ?? 0);

if ($action === 'delete' && $id) {
    $pdo->prepare("DELETE FROM patients WHERE id=?")->execute([$id]);
    set_flash('success', 'Data pasien berhasil dihapus.');
    redirect(url('index.php?page=patients'));
}

$errors = [];
if (is_post()) {
    $data = [
        'kode_pasien'   => trim($_POST['kode_pasien'] ?? ''),
        'nama'          => trim($_POST['nama'] ?? ''),
        'tgl_lahir'     => trim($_POST['tgl_lahir'] ?? ''),
        'jenis_kelamin' => trim($_POST['jenis_kelamin'] ?? ''),
        'no_hp'         => trim($_POST['no_hp'] ?? ''),
        'alamat'        => trim($_POST['alamat'] ?? ''),
        'status'        => trim($_POST['status'] ?? 'aktif'),
    ];
    $errors = require_fields($data, ['kode_pasien','nama','tgl_lahir','jenis_kelamin','no_hp','status']);

    if (!$errors) {
        if ((int)($_POST['id'] ?? 0) > 0) {
            $id2 = (int)$_POST['id'];
            $pdo->prepare("UPDATE patients SET kode_pasien=?, nama=?, tgl_lahir=?, jenis_kelamin=?, no_hp=?, alamat=?, status=?, updated_at=NOW() WHERE id=?")
                ->execute([$data['kode_pasien'],$data['nama'],$data['tgl_lahir'],$data['jenis_kelamin'],$data['no_hp'],$data['alamat'],$data['status'],$id2]);
            set_flash('success', 'Data pasien berhasil diperbarui.');
        } else {
            $pdo->prepare("INSERT INTO patients (kode_pasien,nama,tgl_lahir,jenis_kelamin,no_hp,alamat,status,created_at,updated_at) VALUES (?,?,?,?,?,?,?,NOW(),NOW())")
                ->execute([$data['kode_pasien'],$data['nama'],$data['tgl_lahir'],$data['jenis_kelamin'],$data['no_hp'],$data['alamat'],$data['status']]);
            set_flash('success', 'Pasien baru berhasil ditambahkan.');
        }
        redirect(url('index.php?page=patients'));
    } else {
        $action = 'form';
        $id = (int)($_POST['id'] ?? 0);
    }
}

$edit = null;
if ($action === 'form' && $id) {
    $stmt = $pdo->prepare("SELECT * FROM patients WHERE id=?");
    $stmt->execute([$id]);
    $edit = $stmt->fetch();
}

$q = trim($_GET['q'] ?? '');
$params = [];
$where = "";
if ($q !== '') {
    $where = "WHERE kode_pasien LIKE ? OR nama LIKE ? OR no_hp LIKE ?";
    $like = "%$q%";
    $params = [$like, $like, $like];
}
$stmt = $pdo->prepare("SELECT * FROM patients $where ORDER BY id DESC");
$stmt->execute($params);
$rows = $stmt->fetchAll();

$isEdit = (bool)$edit;
?>

<!-- HERO HEADER -->
<div class="page-hero mb-4">
  <div class="d-flex flex-wrap align-items-center justify-content-between gap-3">
    <div>
      <div class="text-uppercase small opacity-75"></div>
      <h1 class="h3 mb-1 fw-bold"><?= $action === 'form' ? ($isEdit ? 'Edit Pasien' : 'Tambah Pasien') : 'Data Pasien' ?></h1>
      <div class="text-secondary">
        <?= $action === 'form'
              ? 'Lengkapi informasi pasien untuk kebutuhan layanan klinik.'
              : 'Kelola data pasien, kontak, dan status aktif.' ?>
      </div>
    </div>

    <?php if ($action !== 'form'): ?>
      <a class="btn btn-primary px-4" href="<?= url('index.php?page=patients&action=form') ?>">
        <i class="bi bi-plus-lg me-1"></i> Tambah Pasien
      </a>
    <?php endif; ?>
  </div>
</div>

<?php if ($action === 'form'): ?>

<!-- FORM CARD -->
<div class="card">
  <div class="card-body">
    <?php if ($errors): ?>
      <div class="alert alert-danger">
        <div class="fw-semibold mb-1"><i class="bi bi-exclamation-triangle me-1"></i> Periksa input berikut:</div>
        <ul class="mb-0">
          <?php foreach ($errors as $er): ?><li><?= e($er) ?></li><?php endforeach; ?>
        </ul>
      </div>
    <?php endif; ?>

    <form method="post" class="row g-3">
      <input type="hidden" name="id" value="<?= e((string)($edit['id'] ?? ($_POST['id'] ?? ''))) ?>">

      <div class="col-md-4">
        <label class="form-label fw-semibold">Kode Pasien</label>
        <input name="kode_pasien" class="form-control" placeholder="Contoh: P-001"
               value="<?= e($edit['kode_pasien'] ?? ($_POST['kode_pasien'] ?? '')) ?>">
      </div>

      <div class="col-md-8">
        <label class="form-label fw-semibold">Nama Pasien</label>
        <input name="nama" class="form-control" placeholder="Contoh: Budi Santoso"
               value="<?= e($edit['nama'] ?? ($_POST['nama'] ?? '')) ?>">
      </div>

      <div class="col-md-4">
        <label class="form-label fw-semibold">Tanggal Lahir</label>
        <input type="date" name="tgl_lahir" class="form-control"
               value="<?= e($edit['tgl_lahir'] ?? ($_POST['tgl_lahir'] ?? '')) ?>">
      </div>

      <div class="col-md-4">
        <label class="form-label fw-semibold">Jenis Kelamin</label>
        <?php $jk = $edit['jenis_kelamin'] ?? ($_POST['jenis_kelamin'] ?? 'L'); ?>
        <select name="jenis_kelamin" class="form-select">
          <option value="L" <?= $jk==='L'?'selected':'' ?>>Laki-laki (L)</option>
          <option value="P" <?= $jk==='P'?'selected':'' ?>>Perempuan (P)</option>
        </select>
      </div>

      <div class="col-md-4">
        <label class="form-label fw-semibold">No HP</label>
        <input name="no_hp" class="form-control" placeholder="Contoh: 081234567890"
               value="<?= e($edit['no_hp'] ?? ($_POST['no_hp'] ?? '')) ?>">
      </div>

      <div class="col-md-6">
        <label class="form-label fw-semibold">Status</label>
        <select name="status" class="form-select">
          <?php $st = $edit['status'] ?? ($_POST['status'] ?? 'aktif'); ?>
          <option value="aktif" <?= $st==='aktif'?'selected':'' ?>>aktif</option>
          <option value="nonaktif" <?= $st==='nonaktif'?'selected':'' ?>>nonaktif</option>
        </select>
      </div>

      <div class="col-12">
        <label class="form-label fw-semibold">Alamat</label>
        <textarea name="alamat" class="form-control" rows="2" placeholder="Alamat lengkap pasien"><?= e($edit['alamat'] ?? ($_POST['alamat'] ?? '')) ?></textarea>
      </div>

      <div class="col-12 d-flex flex-wrap gap-2 pt-2">
        <button class="btn btn-primary px-4">
          <i class="bi bi-check2-circle me-1"></i> Simpan
        </button>
        <a class="btn btn-outline-secondary" href="<?= url('index.php?page=patients') ?>">
          <i class="bi bi-arrow-left me-1"></i> Kembali
        </a>
      </div>
    </form>
  </div>
</div>

<?php else: ?>

<!-- LIST CARD -->
<div class="card">
  <div class="card-body">
    <form class="row g-2 align-items-center mb-3" method="get">
      <input type="hidden" name="page" value="patients">

      <div class="col-12 col-md-6">
        <div class="input-group">
          <span class="input-group-text bg-white"><i class="bi bi-search"></i></span>
          <input class="form-control" name="q" placeholder="Cari pasien (kode / nama / no HP)..."
                 value="<?= e($q) ?>">
        </div>
      </div>

      <div class="col-auto">
        <button class="btn btn-outline-primary">
          <i class="bi bi-funnel me-1"></i> Cari
        </button>
      </div>

      <div class="col-auto">
        <a class="btn btn-outline-secondary" href="<?= url('index.php?page=patients') ?>">Reset</a>
      </div>
    </form>

    <div class="table-responsive">
      <table class="table table-modern align-middle">
        <thead>
          <tr>
            <th style="width:70px">No</th>
            <th>Kode</th>
            <th>Nama</th>
            <th>L/P</th>
            <th>No HP</th>
            <th>Status</th>
            <th class="text-end" style="width:140px">Aksi</th>
          </tr>
        </thead>
        <tbody>
          <?php if (!$rows): ?>
            <tr><td colspan="7" class="text-center text-secondary py-4">Belum ada data pasien.</td></tr>
          <?php endif; ?>

          <?php foreach ($rows as $i => $r): ?>
            <tr>
              <td><?= $i+1 ?></td>
              <td class="fw-semibold"><?= e($r['kode_pasien']) ?></td>
              <td><?= e($r['nama']) ?></td>
              <td><?= e($r['jenis_kelamin']) ?></td>
              <td><?= e($r['no_hp']) ?></td>
              <td><?= badge_status($r['status']) ?></td>
              <td class="text-end">
                <a class="btn btn-outline-primary btn-sm icon-btn"
                   href="<?= url('index.php?page=patients&action=form&id='.(int)$r['id']) ?>"
                   title="Edit">
                  <i class="bi bi-pencil"></i>
                </a>
                <a class="btn btn-outline-danger btn-sm icon-btn"
                   onclick="return confirm('Hapus pasien ini?')"
                   href="<?= url('index.php?page=patients&action=delete&id='.(int)$r['id']) ?>"
                   title="Hapus">
                  <i class="bi bi-trash"></i>
                </a>
              </td>
            </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>

<?php endif; ?>
