<?php
require_once __DIR__ . '/_shared.php';

$action = $_GET['action'] ?? 'list';
$id = (int)($_GET['id'] ?? 0);

if ($action === 'delete' && $id) {
    $pdo->prepare("DELETE FROM services WHERE id=?")->execute([$id]);
    set_flash('success', 'Data layanan berhasil dihapus.');
    redirect(url('index.php?page=services'));
}

$errors = [];
if (is_post()) {
    $data = [
        'kode_layanan'  => trim($_POST['kode_layanan'] ?? ''),
        'nama'          => trim($_POST['nama'] ?? ''),
        'deskripsi'     => trim($_POST['deskripsi'] ?? ''),
        'harga'         => (float)($_POST['harga'] ?? 0),
        'durasi_menit'  => (int)($_POST['durasi_menit'] ?? 0),
        'status'        => trim($_POST['status'] ?? 'aktif'),
    ];
    $errors = require_fields($data, ['kode_layanan','nama','harga','durasi_menit','status']);

    if (!$errors) {
        if ((int)($_POST['id'] ?? 0) > 0) {
            $id2 = (int)$_POST['id'];
            $pdo->prepare("UPDATE services SET kode_layanan=?, nama=?, deskripsi=?, harga=?, durasi_menit=?, status=?, updated_at=NOW() WHERE id=?")
                ->execute([$data['kode_layanan'],$data['nama'],$data['deskripsi'],$data['harga'],$data['durasi_menit'],$data['status'],$id2]);
            set_flash('success', 'Data layanan berhasil diperbarui.');
        } else {
            $pdo->prepare("INSERT INTO services (kode_layanan,nama,deskripsi,harga,durasi_menit,status,created_at,updated_at) VALUES (?,?,?,?,?,?,NOW(),NOW())")
                ->execute([$data['kode_layanan'],$data['nama'],$data['deskripsi'],$data['harga'],$data['durasi_menit'],$data['status']]);
            set_flash('success', 'Layanan baru berhasil ditambahkan.');
        }
        redirect(url('index.php?page=services'));
    } else {
        $action = 'form';
        $id = (int)($_POST['id'] ?? 0);
    }
}

$edit = null;
if ($action === 'form' && $id) {
    $stmt = $pdo->prepare("SELECT * FROM services WHERE id=?");
    $stmt->execute([$id]);
    $edit = $stmt->fetch();
}

$q = trim($_GET['q'] ?? '');
$params = [];
$where = "";
if ($q !== '') {
    $where = "WHERE kode_layanan LIKE ? OR nama LIKE ? OR deskripsi LIKE ?";
    $like = "%$q%";
    $params = [$like, $like, $like];
}
$stmt = $pdo->prepare("SELECT * FROM services $where ORDER BY id DESC");
$stmt->execute($params);
$rows = $stmt->fetchAll();

$isEdit = (bool)$edit;
?>

<!-- HERO HEADER -->
<div class="page-hero mb-4">
  <div class="d-flex flex-wrap align-items-center justify-content-between gap-3">
    <div>
      <div class="text-uppercase small opacity-75"></div>
      <h1 class="h3 mb-1 fw-bold"><?= $action === 'form' ? ($isEdit ? 'Edit Layanan' : 'Tambah Layanan') : 'Data Layanan' ?></h1>
      <div class="text-secondary">
        <?= $action === 'form'
              ? 'Atur nama layanan, harga, durasi, dan status agar reservasi lebih rapi.'
              : 'Kelola layanan klinik—harga dan durasi untuk kebutuhan reservasi.' ?>
      </div>
    </div>

    <?php if ($action !== 'form'): ?>
      <a class="btn btn-primary px-4" href="<?= url('index.php?page=services&action=form') ?>">
        <i class="bi bi-plus-lg me-1"></i> Tambah Layanan
      </a>
    <?php endif; ?>
  </div>
</div>

<?php if ($action === 'form'): ?>

<!-- FORM CARD -->
<div class="card">
  <div class="card-body">
    <?php if ($errors): ?>
      <div class="alert alert-danger">
        <div class="fw-semibold mb-1"><i class="bi bi-exclamation-triangle me-1"></i> Periksa input berikut:</div>
        <ul class="mb-0">
          <?php foreach ($errors as $er): ?><li><?= e($er) ?></li><?php endforeach; ?>
        </ul>
      </div>
    <?php endif; ?>

    <form method="post" class="row g-3">
      <input type="hidden" name="id" value="<?= e((string)($edit['id'] ?? ($_POST['id'] ?? ''))) ?>">

      <div class="col-md-4">
        <label class="form-label fw-semibold">Kode Layanan</label>
        <input name="kode_layanan" class="form-control" placeholder="Contoh: L-001"
               value="<?= e($edit['kode_layanan'] ?? ($_POST['kode_layanan'] ?? '')) ?>">
      </div>

      <div class="col-md-8">
        <label class="form-label fw-semibold">Nama Layanan</label>
        <input name="nama" class="form-control" placeholder="Contoh: Konsultasi Umum"
               value="<?= e($edit['nama'] ?? ($_POST['nama'] ?? '')) ?>">
      </div>

      <div class="col-md-4">
        <label class="form-label fw-semibold">Harga (Rp)</label>
        <input type="number" name="harga" class="form-control" min="0" step="1000" placeholder="Contoh: 50000"
               value="<?= e((string)($edit['harga'] ?? ($_POST['harga'] ?? 0))) ?>">
        <div class="form-text">Isi angka tanpa titik/koma.</div>
      </div>

      <div class="col-md-4">
        <label class="form-label fw-semibold">Durasi (menit)</label>
        <input type="number" name="durasi_menit" class="form-control" min="0" step="5" placeholder="Contoh: 30"
               value="<?= e((string)($edit['durasi_menit'] ?? ($_POST['durasi_menit'] ?? 0))) ?>">
      </div>

      <div class="col-md-4">
        <label class="form-label fw-semibold">Status</label>
        <select name="status" class="form-select">
          <?php $st = $edit['status'] ?? ($_POST['status'] ?? 'aktif'); ?>
          <option value="aktif" <?= $st==='aktif'?'selected':'' ?>>aktif</option>
          <option value="nonaktif" <?= $st==='nonaktif'?'selected':'' ?>>nonaktif</option>
        </select>
      </div>

      <div class="col-12">
        <label class="form-label fw-semibold">Deskripsi (opsional)</label>
        <textarea name="deskripsi" class="form-control" rows="2" placeholder="Contoh: Pemeriksaan umum + konsultasi dokter"><?= e($edit['deskripsi'] ?? ($_POST['deskripsi'] ?? '')) ?></textarea>
      </div>

      <div class="col-12 d-flex flex-wrap gap-2 pt-2">
        <button class="btn btn-primary px-4">
          <i class="bi bi-check2-circle me-1"></i> Simpan
        </button>
        <a class="btn btn-outline-secondary" href="<?= url('index.php?page=services') ?>">
          <i class="bi bi-arrow-left me-1"></i> Kembali
        </a>
      </div>
    </form>
  </div>
</div>

<?php else: ?>

<!-- LIST CARD -->
<div class="card">
  <div class="card-body">
    <form class="row g-2 align-items-center mb-3" method="get">
      <input type="hidden" name="page" value="services">

      <div class="col-12 col-md-6">
        <div class="input-group">
          <span class="input-group-text bg-white"><i class="bi bi-search"></i></span>
          <input class="form-control" name="q" placeholder="Cari layanan (kode / nama / deskripsi)..."
                 value="<?= e($q) ?>">
        </div>
      </div>

      <div class="col-auto">
        <button class="btn btn-outline-primary">
          <i class="bi bi-funnel me-1"></i> Cari
        </button>
      </div>

      <div class="col-auto">
        <a class="btn btn-outline-secondary" href="<?= url('index.php?page=services') ?>">Reset</a>
      </div>
    </form>

    <div class="table-responsive">
      <table class="table table-modern align-middle">
        <thead>
          <tr>
            <th style="width:70px">No</th>
            <th>Kode</th>
            <th>Nama</th>
            <th>Harga</th>
            <th>Durasi</th>
            <th>Status</th>
            <th class="text-end" style="width:140px">Aksi</th>
          </tr>
        </thead>
        <tbody>
          <?php if (!$rows): ?>
            <tr><td colspan="7" class="text-center text-secondary py-4">Belum ada data layanan.</td></tr>
          <?php endif; ?>

          <?php foreach ($rows as $i => $r): ?>
            <tr>
              <td><?= $i+1 ?></td>
              <td class="fw-semibold"><?= e($r['kode_layanan']) ?></td>
              <td>
                <div class="fw-semibold"><?= e($r['nama']) ?></div>
                <?php if (!empty($r['deskripsi'])): ?>
                  <div class="small text-secondary"><?= e($r['deskripsi']) ?></div>
                <?php endif; ?>
              </td>
              <td><?= e(format_rupiah($r['harga'])) ?></td>
              <td><?= e((string)$r['durasi_menit']) ?> menit</td>
              <td><?= badge_status($r['status']) ?></td>
              <td class="text-end">
                <a class="btn btn-outline-primary btn-sm icon-btn"
                   href="<?= url('index.php?page=services&action=form&id='.(int)$r['id']) ?>"
                   title="Edit">
                  <i class="bi bi-pencil"></i>
                </a>
                <a class="btn btn-outline-danger btn-sm icon-btn"
                   onclick="return confirm('Hapus layanan ini?')"
                   href="<?= url('index.php?page=services&action=delete&id='.(int)$r['id']) ?>"
                   title="Hapus">
                  <i class="bi bi-trash"></i>
                </a>
              </td>
            </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>

<?php endif; ?>
