<?php
require_once __DIR__ . '/_shared.php';
require_admin();

$action = $_GET['action'] ?? 'list';
$id = (int)($_GET['id'] ?? 0);

if ($action === 'delete' && $id) {
    $pdo->prepare("DELETE FROM users WHERE id=?")->execute([$id]);
    set_flash('success', 'User berhasil dihapus.');
    redirect(url('index.php?page=users'));
}

$errors = [];
if (is_post()) {
    $data = [
        'username' => trim($_POST['username'] ?? ''),
        'nama'     => trim($_POST['nama'] ?? ''),
        'role'     => trim($_POST['role'] ?? 'user'),
        'status'   => trim($_POST['status'] ?? 'aktif'),
    ];
    $password = $_POST['password'] ?? '';
    $errors = require_fields($data, ['username','nama','role','status']);

    $uid = (int)($_POST['id'] ?? 0);

    if ($uid === 0 && trim($password) === '') {
        $errors[] = "Password wajib diisi untuk user baru.";
    }

    if (!$errors) {
        $stmt = $pdo->prepare("SELECT id FROM users WHERE username=? AND id<>?");
        $stmt->execute([$data['username'], $uid]);
        if ($stmt->fetch()) {
            $errors[] = "Username sudah digunakan.";
        }
    }

    if (!$errors) {
        if ($uid > 0) {
            $pdo->prepare("UPDATE users SET username=?, nama=?, role=?, status=?, updated_at=NOW() WHERE id=?")
                ->execute([$data['username'],$data['nama'],$data['role'],$data['status'],$uid]);

            if (trim($password) !== '') {
                $hash = password_hash($password, PASSWORD_DEFAULT);
                $pdo->prepare("UPDATE users SET password_hash=? WHERE id=?")->execute([$hash,$uid]);
            }

            set_flash('success', 'User berhasil diperbarui.');
        } else {
            $hash = password_hash($password, PASSWORD_DEFAULT);
            $pdo->prepare("INSERT INTO users (username,password_hash,nama,role,status,created_at,updated_at) VALUES (?,?,?,?,?,NOW(),NOW())")
                ->execute([$data['username'],$hash,$data['nama'],$data['role'],$data['status']]);
            set_flash('success', 'User berhasil ditambahkan.');
        }
        redirect(url('index.php?page=users'));
    } else {
        $action = 'form';
        $id = $uid;
    }
}

$edit = null;
if ($action === 'form' && $id) {
    $stmt = $pdo->prepare("SELECT * FROM users WHERE id=?");
    $stmt->execute([$id]);
    $edit = $stmt->fetch();
}

$q = trim($_GET['q'] ?? '');
$params = [];
$where = "";
if ($q !== '') {
    $where = "WHERE username LIKE ? OR nama LIKE ? OR role LIKE ?";
    $like = "%$q%";
    $params = [$like, $like, $like];
}
$stmt = $pdo->prepare("SELECT id, username, nama, role, status, created_at, last_login FROM users $where ORDER BY id DESC");
$stmt->execute($params);
$rows = $stmt->fetchAll();

$isEdit = (bool)$edit;
?>

<!-- HERO HEADER -->
<div class="page-hero mb-4">
  <div class="d-flex flex-wrap align-items-center justify-content-between gap-3">
    <div>
      <div class="text-uppercase small opacity-75"></div>
      <h1 class="h3 mb-1 fw-bold"><?= $action === 'form' ? ($isEdit ? 'Edit Pengguna' : 'Tambah Pengguna') : 'Manajemen Pengguna' ?></h1>
      <div class="text-secondary">
        <?= $action === 'form'
              ? 'Atur username, peran, status, dan password pengguna.'
              : 'Kelola akses admin dan user agar sistem tetap aman.' ?>
      </div>
    </div>

    <?php if ($action !== 'form'): ?>
      <a class="btn btn-primary px-4" href="<?= url('index.php?page=users&action=form') ?>">
        <i class="bi bi-plus-lg me-1"></i> Tambah Pengguna
      </a>
    <?php endif; ?>
  </div>
</div>

<?php if ($action === 'form'): ?>

<div class="card">
  <div class="card-body">

    <?php if ($errors): ?>
      <div class="alert alert-danger">
        <div class="fw-semibold mb-1"><i class="bi bi-exclamation-triangle me-1"></i> Periksa input berikut:</div>
        <ul class="mb-0">
          <?php foreach ($errors as $er): ?><li><?= e($er) ?></li><?php endforeach; ?>
        </ul>
      </div>
    <?php endif; ?>

    <form method="post" class="row g-3">
      <input type="hidden" name="id" value="<?= e((string)($edit['id'] ?? ($_POST['id'] ?? ''))) ?>">

      <div class="col-md-4">
        <label class="form-label fw-semibold">Username</label>
        <input name="username" class="form-control" placeholder="Contoh: admin"
               value="<?= e($edit['username'] ?? ($_POST['username'] ?? '')) ?>">
      </div>

      <div class="col-md-8">
        <label class="form-label fw-semibold">Nama</label>
        <input name="nama" class="form-control" placeholder="Contoh: Administrator"
               value="<?= e($edit['nama'] ?? ($_POST['nama'] ?? '')) ?>">
      </div>

      <div class="col-md-4">
        <label class="form-label fw-semibold">Role</label>
        <?php $role = $edit['role'] ?? ($_POST['role'] ?? 'user'); ?>
        <select name="role" class="form-select">
          <option value="admin" <?= $role==='admin'?'selected':'' ?>>admin</option>
          <option value="user" <?= $role==='user'?'selected':'' ?>>user</option>
        </select>
      </div>

      <div class="col-md-4">
        <label class="form-label fw-semibold">Status</label>
        <?php $st = $edit['status'] ?? ($_POST['status'] ?? 'aktif'); ?>
        <select name="status" class="form-select">
          <option value="aktif" <?= $st==='aktif'?'selected':'' ?>>aktif</option>
          <option value="nonaktif" <?= $st==='nonaktif'?'selected':'' ?>>nonaktif</option>
        </select>
      </div>

      <div class="col-md-4">
        <label class="form-label fw-semibold">Password <?= $edit ? '<span class="text-secondary small">(kosongkan jika tidak diubah)</span>' : '' ?></label>
        <input type="password" name="password" class="form-control" placeholder="<?= $edit ? '••••••••' : 'Masukkan password' ?>">
      </div>

      <div class="col-12 d-flex flex-wrap gap-2 pt-2">
        <button class="btn btn-primary px-4">
          <i class="bi bi-check2-circle me-1"></i> Simpan
        </button>
        <a class="btn btn-outline-secondary" href="<?= url('index.php?page=users') ?>">
          <i class="bi bi-arrow-left me-1"></i> Kembali
        </a>
      </div>
    </form>

  </div>
</div>

<?php else: ?>

<div class="card">
  <div class="card-body">

    <form class="row g-2 align-items-center mb-3" method="get">
      <input type="hidden" name="page" value="users">

      <div class="col-12 col-md-6">
        <div class="input-group">
          <span class="input-group-text bg-white"><i class="bi bi-search"></i></span>
          <input class="form-control" name="q" placeholder="Cari pengguna (username / nama / role)..."
                 value="<?= e($q) ?>">
        </div>
      </div>

      <div class="col-auto">
        <button class="btn btn-outline-primary">
          <i class="bi bi-funnel me-1"></i> Cari
        </button>
      </div>

      <div class="col-auto">
        <a class="btn btn-outline-secondary" href="<?= url('index.php?page=users') ?>">Reset</a>
      </div>
    </form>

    <div class="table-responsive">
      <table class="table table-modern align-middle">
        <thead>
          <tr>
            <th style="width:70px">No</th>
            <th>Username</th>
            <th>Nama</th>
            <th>Role</th>
            <th>Status</th>
            <th>Last Login</th>
            <th class="text-end" style="width:140px">Aksi</th>
          </tr>
        </thead>
        <tbody>
          <?php if (!$rows): ?>
            <tr><td colspan="7" class="text-center text-secondary py-4">Belum ada data pengguna.</td></tr>
          <?php endif; ?>

          <?php foreach ($rows as $i => $r): ?>
            <tr>
              <td><?= $i+1 ?></td>
              <td class="fw-semibold"><?= e($r['username']) ?></td>
              <td><?= e($r['nama']) ?></td>
              <td>
                <span class="badge text-bg-<?= ($r['role']==='admin') ? 'primary' : 'secondary' ?>">
                  <?= e($r['role']) ?>
                </span>
              </td>
              <td><?= badge_status($r['status']) ?></td>
              <td><?= e($r['last_login'] ?? '-') ?></td>
              <td class="text-end">
                <a class="btn btn-outline-primary btn-sm icon-btn"
                   href="<?= url('index.php?page=users&action=form&id='.(int)$r['id']) ?>"
                   title="Edit">
                  <i class="bi bi-pencil"></i>
                </a>
                <a class="btn btn-outline-danger btn-sm icon-btn"
                   onclick="return confirm('Hapus user ini?')"
                   href="<?= url('index.php?page=users&action=delete&id='.(int)$r['id']) ?>"
                   title="Hapus">
                  <i class="bi bi-trash"></i>
                </a>
              </td>
            </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
    </div>

  </div>
</div>

<?php endif; ?>
