<?php
require_once __DIR__ . '/../../config/db.php';
require_once __DIR__ . '/../../helpers/functions.php';
require_once __DIR__ . '/../../helpers/auth.php';

$flash = get_flash();
$u = current_user();

$pageActive = $_GET['page'] ?? 'dashboard';
function nav_active(string $key, string $pageActive): string {
  return ($key === $pageActive) ? 'active' : '';
}
?>
<!doctype html>
<html lang="id">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= e(APP_NAME) ?></title>

  <!-- Font modern -->
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">

  <!-- Bootstrap 5 Theme (Bootswatch) -->
  <link href="https://cdn.jsdelivr.net/npm/bootswatch@5.3.3/dist/flatly/bootstrap.min.css" rel="stylesheet">

  <!-- Icons -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css" rel="stylesheet">

  <!-- App css -->
  <link href="<?= url('assets/css/app.css') ?>" rel="stylesheet">
</head>

<body>
<nav class="navbar navbar-expand-lg navbar-light bg-white border-bottom shadow-sm">
  <div class="container-fluid">
    <a class="navbar-brand fw-bold d-flex align-items-center gap-2" href="<?= url('index.php?page=dashboard') ?>">
      <span class="bg-primary text-white rounded-3 px-2 py-1">
        <i class="bi bi-hospital"></i>
      </span>
      <span><?= e(APP_NAME) ?></span>
    </a>

    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navMain">
      <span class="navbar-toggler-icon"></span>
    </button>

    <div class="collapse navbar-collapse" id="navMain">
      <ul class="navbar-nav ms-auto align-items-lg-center gap-lg-2">
        <?php if ($u): ?>
          <li class="nav-item">
            <span class="nav-link text-dark d-flex align-items-center gap-2">
              <i class="bi bi-person-circle"></i>
              <span class="fw-semibold"><?= e($u['nama'] ?? $u['username']) ?></span>
              <span class="badge text-bg-light border"><?= e(strtoupper($u['role'])) ?></span>
            </span>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="<?= url('logout.php') ?>">
              <i class="bi bi-box-arrow-right"></i> Logout
            </a>
          </li>
        <?php endif; ?>
      </ul>
    </div>
  </div>
</nav>

<div class="container-fluid app-shell">
  <div class="row g-0">

    <!-- SIDEBAR -->
    <aside class="col-12 col-lg-2 min-vh-100 sidebar">
      <?php if ($u): ?>
        <div class="p-3 border-bottom">
          <div class="small text-secondary">Akun</div>
          <div class="fw-bold"><?= e($u['nama'] ?? $u['username']) ?></div>
          <div class="small text-secondary"><?= e(ucfirst($u['role'])) ?></div>
        </div>

        <div class="list-group py-2">
          <a class="list-group-item list-group-item-action <?= nav_active('dashboard', $pageActive) ?>"
             href="<?= url('index.php?page=dashboard') ?>">
            <i class="bi bi-speedometer2 me-2"></i> Dashboard
          </a>

          <div class="section-title text-secondary px-3 mt-2">DATA UTAMA</div>
          <a class="list-group-item list-group-item-action <?= nav_active('doctors', $pageActive) ?>"
             href="<?= url('index.php?page=doctors') ?>">
            <i class="bi bi-person-badge me-2"></i> Dokter
          </a>
          <a class="list-group-item list-group-item-action <?= nav_active('patients', $pageActive) ?>"
             href="<?= url('index.php?page=patients') ?>">
            <i class="bi bi-people me-2"></i> Pasien
          </a>
          <a class="list-group-item list-group-item-action <?= nav_active('services', $pageActive) ?>"
             href="<?= url('index.php?page=services') ?>">
            <i class="bi bi-clipboard2-pulse me-2"></i> Layanan
          </a>

          <div class="section-title text-secondary px-3 mt-2">AKTIVITAS</div>
          <a class="list-group-item list-group-item-action <?= nav_active('appointments', $pageActive) ?> <?= nav_active('appointment_view', $pageActive) ?>"
             href="<?= url('index.php?page=appointments') ?>">
            <i class="bi bi-calendar2-check me-2"></i> Reservasi
          </a>

          <?php if (($u['role'] ?? '') === 'admin'): ?>
            <div class="section-title text-secondary px-3 mt-2">PENGATURAN</div>
            <a class="list-group-item list-group-item-action <?= nav_active('users', $pageActive) ?>"
               href="<?= url('index.php?page=users') ?>">
              <i class="bi bi-gear me-2"></i> Pengguna
            </a>
          <?php endif; ?>
        </div>
      <?php endif; ?>
    </aside>

    <!-- CONTENT -->
    <main class="col-12 col-lg-10 p-4">
      <?php if ($flash): ?>
        <div class="alert alert-<?= e($flash['type']) ?> alert-dismissible fade show" role="alert">
          <?= $flash['message'] ?>
          <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
      <?php endif; ?>
